/*------------------------------------------------------------------------------*
 * File Name: FilePublish.c	 													*
 * Creation: Jasmine 08/15/07													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW							*
 * Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY	*
 * Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80							*
 * Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80	*
 * Folger 09/03/07 SUPPORT_MORE_FILE_TYPES										*
 * Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO							*
 * Folger 09/08/07 SUPPORT_PATCH_FILE											*
 * Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM						*
 * Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR			*
 * Folger 09/14/07 SAVE_USER_COMBO_SELECTION									*
 * Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG									*
 * Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR							*
 * CPY 9/22/2007 QA70-10384 CODE_CLEANUP										*
 *	CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH			*
 * Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION						*
 * Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE						*
 * Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION						*
 * Folger 09/28/07 SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE				*
 * EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER			*
 * Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE						*
 * Folger 11/14/07 MAP_DIALOG_CHM_HELP											*
 *	Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE					*
 *	Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST			*
 *	Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES				*
 *	Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED						*
 *	Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER	*
 *	Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER			*
 *	Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL		*
 *	Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE				*
 *	Kit 8/05/2010 ORG-539-S1 HINT_>>_CAN_NOT_SHOW_IN_GROUP_FOLDER_MANAGER		*
 *	Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
 *	Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h" 
#include "FilePublish.h"
#include "INIFileEx.h"				//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
#include "MenuBase.h"				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#include <ocu.h>

#define STR_DLG_NAME						_L("Group Folder Manager")
#define STR_DLG_NAME_TRANSFER_USER_FILES	_L("Transfer User Files")	//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
#define STR_COL_STATUS						_L("Status")

#define COLOR_GRAY				RGB(200,200,200)
#define STR_COLOR_EXPLAINATION	_L("Red : newer \t Green : older \t Blue : identical")

//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
#define STR_SECTION			"UpdateInfo"
#define STR_VERSION			"version"
#define STR_IS_PUBLISHED	"IsPublished"
//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO

#define STR_LAST_SELECTION				"LastSelection"			//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION

#define STR_SPECIFIED_FOLDER			_L("Specified Folder")		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
#define	STR_LAST_SPECIFIED_LOCATION		"LastLocation"
#define	STR_OLD_VERSION_KEY				"OldVersion"
///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF

//------ Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
/*
//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
////------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
//#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|#1;Dialog Themes|#2;Fitting Functions|#3;Import Filters|#4;LabTalk Scripts Files|#5;OriginC Files|#6;Page Templates|#7;Patches|#8;Project Files|#9;Window Themes|#10;XFunctions|#11;Other Files")
////------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|\
											#1;Dialog Themes|\
											#2;Fitting Functions|\
											#3;Import Filters|\
											#4;LabTalk Scripts Files|\
											#5;Database Files|\
											#6;OriginC Files|\
											#7;Package Files|\
											#8;Page Templates|\
											#9;Patches|\
											#10;Project Files|\
											#11;Window Themes|\
											#12;XFunctions|\
											#13;Default Settings|\
											#14;Other Files")
#else
#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|\
											#1;Dialog Themes|\
											#2;Fitting Functions|\
											#3;Import Filters|\
											#4;LabTalk Scripts Files|\
											#5;Database Files|\
											#6;OriginC Files|\
											#7;Page Templates|\
											#8;Patches|\
											#9;Project Files|\
											#10;Window Themes|\
											#11;XFunctions|\
											#12;Default Settings|\
											#13;Other Files")
#endif
//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
*/
#define		STR_FILE_TYPE_OGW				_L("Analysis Templates")
#define		STR_FILE_TYPE_DIALOG_THEME		_L("Dialog Themes")
#define		STR_FILE_TYPE_FDF				_L("Fitting Functions")
#define		STR_FILE_TYPE_IMPORT_FILTER		_L("Import Filters")
#define		STR_FILE_TYPE_OGS				_L("LabTalk Scripts Files")
#define		STR_FILE_TYPE_DATABASE			_L("Database Files")
#define		STR_FILE_TYPE_ORIGINC			_L("OriginC Files")
//#ifdef SUPPORT_PACKAGE_FILES				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_PACKAGE			_L("Package Files")
//#endif										///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_TEMPLATE			_L("Page Templates")
#define		STR_FILE_TYPE_PATCH				_L("Patches")
#define		STR_FILE_TYPE_PROJECT			_L("Project Files")
#define		STR_FILE_TYPE_THEME				_L("Window Themes")
#define		STR_FILE_TYPE_XF				_L("X-Functions")
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
//#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_OMC				_L("Menu Customization Files")
//#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER

#define		STR_FILE_TYPE_DEFAULT_SETTINGS	_L("Default Settings")
#define		STR_FILE_TYPE_OTHER_FILE		_L("Other Files")
//------ End CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
/*
enum
{
	COL_FILE,
	COL_FILESIZE,
	COL_FILEDATE,
	COL_CATEGORY,
	COL_FILETYPE,		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	COL_STATUS,
	COL_NUMS,
};
*/
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

enum
{
	FILE_DATE_OLD 	= -1,
	FILE_DATE_EQUAL,
	FILE_DATE_NEW,
	FILE_NEW,
};

class FileListControl : public GridListControl
{
public:
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//FileListControl(int nID, WndContainer &dlg, int nPath, FilePublishBase *pFilePublish, bool bGroupMgr = true)
	FileListControl(int nID, WndContainer &dlg, bool bSource, FilePublishBase *pFilePublish)
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	{
		m_pFilePublish = pFilePublish;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_nPath = nPath;
		//m_bGroupMgr = bGroupMgr;		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		m_bSource = bSource;
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		Init(nID, dlg);
		UpdateList();
	}
	
	void Init(int nID, WndContainer &dlg)
	{
		GridListControl::Init(nID, dlg);
		SetAllowSelection(true);
		SetSelection(flexSelectionListBox);
		SetEditable();
		
		m_flx.ExplorerBar = flexExSortShow;
		
		vector<string> vsColHeading;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//int nSize = m_pFilePublish->GetColNames(vsColHeading, m_nPath);
		int nSize = m_pFilePublish->GetColNames(vsColHeading, m_bSource);
		m_pFilePublish->GetShownInfo(m_vbShow);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		SetupRowsCols(1, 0,  -1, nSize + 1);
		for (int ii=0; ii<nSize; ii++)
			SetColHeading(ii, vsColHeading[ii]);
		SetupColTypes();						///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		m_nColStatus = nSize;
		SetColHeading(m_nColStatus, STR_COL_STATUS);
		
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//vector<byte> vbHideCols(nSize);
		//vbHideCols.Add(1);
		//LoadHideCols(dlg.Text, "FileListControl", &vbHideCols);
		m_vbShow.Add(false);			// status
		ShowCols(m_vbShow);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//if (GetCols() == COL_NUMS)
			////------ Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
			////m_flx.ColComboList(COL_FILETYPE) = STR_FILE_TYPE_COMBO;
			//m_flx.ColComboList(COL_FILETYPE) = getFileTypeComboString();
			////------
		if (FB_COL_FILETYPE < m_vbShow.GetSize() && m_vbShow[FB_COL_FILETYPE])
			SetColComboList(FB_COL_FILETYPE, getFileTypeComboString());
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//else if (!m_bGroupMgr && GetCols() == COL_STATUS)
			////------ Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
			////m_flx.ColComboList(COL_CATEGORY) = STR_FILE_TYPE_COMBO;
			//m_flx.ColComboList(COL_CATEGORY) = getFileTypeComboString();
			////------
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		ResizeCols();
		SetReady();
	}
	
	void UpdateList()
	{
		ClearAll();
		vector<string> vsFiles;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pFilePublish->GetFiles(m_nPath, vsFiles);
		m_pFilePublish->GetFiles(m_bSource, vsFiles);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		//int nStart = GetTickCount();
		AddRows(vsFiles);
		//Tree trItems;
		//vector<string> vsColHeading;
		//m_pFilePublish->GetColNames(vsColHeading, m_nPath);
		//for (int ii=0; ii<vsColHeading.GetSize(); ii++)
			//vsColHeading[ii].Remove(' ');
				//
		//int nSize = vsFiles.GetSize();
		//for (ii=0; ii<nSize; ii++)
		//{
			//vector<string> vsVals;
			//m_pFilePublish->GetRowInfo(vsFiles[ii], vsVals, m_nPath);
			//TreeNode trNode = trItems.AddNode("File" + ii);
			////trNode.SetAttribute(STR_LABEL_ATTRIB, vsVals[0]);
			//for (int jj=0; jj<vsVals.GetSize(); jj++)
			//{
				//TreeNode tr = trNode.AddNode("Name");
				//tr.SetAttribute(STR_LABEL_ATTRIB, vsVals[jj]);
			//}
		//}
		//UpdateSimpleTree(trItems);
		
		//int nEnd = GetTickCount();
		//printf("Time = %d\n", nEnd - nStart);
	}
	
	int AddRows(const vector<string> &vsFiles)
	{
		int nSize = vsFiles.GetSize();
		int nRowOffset = GetRowOffset();
		int nColOffset = GetColOffset();
		vector<string> vsVals;
		vector<string> vsAdds;		//------ Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//GetColValues(nColOffset + COL_FILE, vsVals, nRowOffset);
		////------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		//if (m_bGroupMgr && GetCols() >= COL_STATUS)
		GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		{
			vector<string> vsCates;
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			//GetColValues(nColOffset + COL_CATEGORY, vsCates, nRowOffset);
			GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			_insert_string_in_vector(vsVals, vsCates);
		}
		//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		for (int ii=0; ii<nSize; ii++)
		{
			int nIndex = vsVals.Find(vsFiles[ii]);
			if (nIndex < 0)
			{
				//------ Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
				//vector<string> vsVals;
				//m_pFilePublish->GetRowInfo(vsFiles[ii], vsVals, m_nPath);
				//AddRow(vsVals);
				vector<string> vsTmp;
				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				//m_pFilePublish->GetRowInfo(vsFiles[ii], vsTmp, m_nPath);
				m_pFilePublish->GetRowInfo(vsFiles[ii], vsTmp, m_bSource);
				///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				string strTmp;
				strTmp.SetTokens(vsTmp, '|');
				vsAdds.Add(strTmp);
				//------ End ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
			}
			else
			{
				SetRowProperties(nIndex + nRowOffset, FILE_DATE_EQUAL);
			}
		}
		
		AddRow(vsAdds);		//------ Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
		
		ResizeCols();
		
		return nSize;
	}
	//------ Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
	//int AddRow(const vector<string> &vsVals)
	//{
		//int nSize = vsVals.GetSize();
		//
		//int nRow = GetRows();
		//SetRows(nRow + 1 - GetRowOffset());		
		//int nColOffset = GetColOffset();
		//
		//for (int ii=0; ii<nSize; ii++)
		//{
			//SetCell(nRow, ii + nColOffset, vsVals[ii]);
		//}
		//
		//SetRowProperties(nRow, FILE_DATE_EQUAL);
		//
		//return vsVals.GetSize();
	//}
	
	int AddRow(const vector<string> &vsAdds)
	{
		int nSize = vsAdds.GetSize();
		int nRow = GetRows();
		SetRows(nRow + nSize - GetRowOffset());
		int nColOffset = GetColOffset();
		
		for (int ii=0; ii<nSize; ii++)
		{
			vector<string> vsTmp;
			vsAdds[ii].GetTokens(vsTmp, '|');
			for (int jj=0; jj<vsTmp.GetSize(); jj++)
			{
				SetCell(nRow + ii, jj + nColOffset, vsTmp[jj]);
			}
			SetRowProperties(nRow + ii, FILE_DATE_EQUAL);
		}
		return vsAdds.GetSize();
	}
	//------ End ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW
	
	//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	//int FilterSelected(vector<string> &vsFiles, bool bAdd = false)
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//int FilterSelected(vector<string> &vsFiles)
	int FilterSelected(vector<string> &vsFiles, bool bFilterOlder = false, vector<bool>* pvbOlder = NULL)
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	{
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vsFiles.SetSize(0);
		if(pvbOlder)
			pvbOlder->SetSize(0);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vector<uint> vnSelected;
		
		GetSelRows(vnSelected);
		int nSize = vnSelected.GetSize();
		int nRowOffset = GetRowOffset();
		int nColOffset = GetColOffset();
		
		for (int ii=0; ii<nSize; ii++)
		{
			int nFileStatus = atoi(GetCell(vnSelected[ii], nColOffset + m_nColStatus));
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, only filter out the identical files, support moving older files from 7.5 to 8.1 ect
			//if (nFileStatus > FILE_DATE_EQUAL)
			if (nFileStatus != FILE_DATE_EQUAL && (!bFilterOlder || nFileStatus > FILE_DATE_EQUAL) )
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			{
				//------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
				//vsFiles.Add(GetCell(vnSelected[ii], nColOffset + COL_FILE));
				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				//string strVal = GetCell(vnSelected[ii], nColOffset + COL_FILE);
				//if (m_bGroupMgr && GetCols() >= COL_STATUS)
					//strVal = GetCell(vnSelected[ii], nColOffset + COL_CATEGORY) + strVal;
				string strVal = GetCell(vnSelected[ii], nColOffset + FB_COL_CATEGORY) + GetCell(vnSelected[ii], nColOffset + FB_COL_FILE);
				///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				vsFiles.Add(strVal);
				//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
				//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				//if (bAdd)
				//{
					//SetRowProperties(vnSelected[ii], FILE_DATE_EQUAL);
					//m_flx.IsSelected(vnSelected[ii]) = false;
				//}
				//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				if(pvbOlder)
					pvbOlder->Add(nFileStatus < FILE_DATE_EQUAL);
				///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			}
		}
		
		return vsFiles.GetSize();
	}
	
	int GetSelFiles(vector<string> &vsFiles)
	{
		vector<uint> vnSelected;
		
		GetSelRows(vnSelected);
		int nSize = vnSelected.GetSize();
		int nColOffset = GetColOffset();
		
		for (int ii=vnSelected.GetSize()-1; ii>=0; ii--)
		{
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			//string strVal = GetCell(vnSelected[ii], nColOffset + COL_FILE);
			//if (m_bGroupMgr && GetCols() >= COL_STATUS)
				//strVal = GetCell(vnSelected[ii], nColOffset + COL_CATEGORY) + strVal;
			string strVal = GetCell(vnSelected[ii], nColOffset + FB_COL_CATEGORY) + GetCell(vnSelected[ii], nColOffset + FB_COL_FILE);
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			vsFiles.Add(strVal);
		}
		return vsFiles.GetSize();
	}
	
	int RemoveSelRows(const vector<string> &vsFiles)
	{
		vector<string> vsVals;
		int nRowOffset = GetRowOffset();
		int nColOffset = GetColOffset();
		int nRow = GetSelectedRow();
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//GetColValues(nColOffset + COL_FILE, vsVals, nRowOffset);
		//if (m_bGroupMgr && GetCols() >= COL_STATUS)
		GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		{
			vector<string> vsCates;
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			//GetColValues(nColOffset + COL_CATEGORY, vsCates, nRowOffset);
			GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			_insert_string_in_vector(vsVals, vsCates);
		}
		
		for (int ii=0; ii<vsFiles.GetSize(); ii++)
		{
			int nIndex = vsVals.Find(vsFiles[ii]);
			if (nIndex >= 0)
			{
				DeleteRow(nRowOffset + nIndex);
			}
		}
		
		selectRow(nRow);
		return vsFiles.GetSize();
	}
	//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	//void RestoreItemsStatus(const vector<string> &vsFiles)
	void RestoreItemsStatus(const vector<string> &vsFiles, bool bPublish = true)
	//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	{
		int nSize = vsFiles.GetSize();
		int nRowOffset = GetRowOffset();
		int nColOffset = GetColOffset();
		vector<string> vsVals;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//GetColValues(nColOffset + COL_FILE, vsVals, nRowOffset);
		////------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		//if (m_bGroupMgr && GetCols() >= COL_STATUS)
		GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		{
			vector<string> vsCates;
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			//GetColValues(nColOffset + COL_CATEGORY, vsCates, nRowOffset);
			//_insert_string_in_vector(vsVals, vsCates);
			if(m_pFilePublish->IsSrcPathSpecified())			// can not get category info from gui
			{
				for(int nFile=vsVals.GetSize()-1; nFile >= 0; nFile--)		// all file type
				{
					string strCategory = m_pFilePublish->GetDestCategory(vsVals[nFile]);
					if(!strCategory.IsEmpty())
						vsVals[nFile] = strCategory + vsVals[nFile];
				}
			}
			else
			{
				GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);
				_insert_string_in_vector(vsVals, vsCates);
			}
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		}
		//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		for (int ii=0; ii<nSize; ii++)
		{
			int nIndex = vsVals.Find(vsFiles[ii]);
			if (nIndex >= 0)
			{
				//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				//SetRowProperties(nRowOffset + nIndex, FILE_NEW);
				if (bPublish)
				{
					SetRowProperties(nRowOffset + nIndex, FILE_DATE_EQUAL);
					SetIsSelected(nRowOffset + nIndex, false);
				}
				else
				{
					SetRowProperties(nRowOffset + nIndex, FILE_NEW);
				}
				//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
			}
		}
	}
	
	int GetColStatus()
	{
		return m_nColStatus;
	}
	//set cell color of COL_FILE, and value of col m_nColStatus
	void SetRowProperties(int nRow,int nFileStatus)
	{
		int nColOffset = GetColOffset();
		int nColor;
		switch (nFileStatus)
		{
		case FILE_DATE_EQUAL:
			nColor = COLOR_BLUE;
			break;
		case FILE_NEW:
			nColor = COLOR_BLACK;
			break;
		default:
			break;
		}
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//SetCellColor(nRow, nColOffset + COL_FILE, nColor);
		SetCellColor(nRow, nColOffset + FB_COL_FILE, nColor);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		SetCell(nRow, nColOffset + m_nColStatus, nFileStatus);
	}
	
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		int nRow, nCol;
		if(!GetMouseCell(nRow, nCol)) 
			return;
		
		string strTooltips;
		if( nRow >= 0 && nRow < GetRowOffset() )
		{
			if(m_bSource)
				strTooltips = m_pFilePublish->GetSrcPath();
			else
				strTooltips = m_pFilePublish->GetDestPath();
		}
		SetToolTipsText(strTooltips);
	}

	void OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		if(nButton != MK_RBUTTON || nShift != 0)
			return;

		int nRow = m_flx.MouseRow;
		int nCol = m_flx.MouseCol;
		if(nCol < 0)
			return;

		vector<uint> vnRows;
		GetSelRows(vnRows);
		if( nRow >= GetRowOffset() )
		{
			vector<uint> vec;
			if( vnRows.Find(vec, nRow) <= 0)
			{
				SelRow(nRow);
				vnRows.SetSize(1);
				vnRows[0] = nRow;
			}
		}
		else
		{
			RemoveSelection();
			vnRows.SetSize(0);
		}
		if(vnRows.GetSize() > 1)
			return;
		
		bool bSelection = vnRows.GetSize() > 0;

		MenuBase MyMenu;
		string strMenuText = bSelection ? _L("Open Containing Folder") : _L("Open Folder");
		MyMenu.Add(strMenuText, MenuBase::OnMenuItem, MF_STRING);

		int    nx = XTwipsToPixels(X);
		int    ny = YTwipsToPixels(Y);
        ClientToScreen(nx, ny);

		int nRet = MyMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if( nRet >= 0 )
		{
			string strFullPathFile;
			if(bSelection)
			{
				string 	strSrcFullPathFile, strDestFullPathFile;
				strSrcFullPathFile = strDestFullPathFile = GetCell(vnRows[0], GetColOffset() + FB_COL_CATEGORY) + GetCell(vnRows[0], GetColOffset() + FB_COL_FILE);
				m_pFilePublish->GetFileFullPath(strSrcFullPathFile, strDestFullPathFile);
				if(m_bSource)
					strFullPathFile = strSrcFullPathFile;
				else
					strFullPathFile = strDestFullPathFile;
			}
			else
			{
				strFullPathFile = m_bSource ? m_pFilePublish->GetSrcPath() : m_pFilePublish->GetDestPath();
			}
			okutil_open_os_explorer(strFullPathFile);
		}
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
protected:
	void	SetupColTypes()
	{
		int nCol;
		for(nCol = 0; nCol < m_flx.Cols; nCol++)
		{
			switch(nCol)
			{
			case FB_COL_FILE:
			case FB_COL_CATEGORY:
				SetColDataType(nCol, flexDTString);
				break;
			case FB_COL_FILETYPE:
				SetColDataType(nCol, flexDTShort);
				break;
			case FB_COL_FILESIZE:
				SetColDataType(nCol, flexDTLong);
				break;
			case FB_COL_FILEDATE:
				SetColDataType(nCol, flexDTDate);
				break;
			default:
			}
		}		
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
private:
	void selectRow(int nRow = -1)
	{
		if(GetRows() <= 0)
			return;
		
		while(nRow >= GetRows())
			nRow--;
			
		if(nRow < 0)
			nRow = GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		if( nRow < 0 )
			nRow = 0;
		
		if (nRow != 0) SelRow(nRow);	
	}
	
	//------ Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
	string	getFileTypeComboString()
	{
		vector<string>	vsFileTypes;
		vsFileTypes.Add(STR_FILE_TYPE_OGW);
		vsFileTypes.Add(STR_FILE_TYPE_DIALOG_THEME);
		vsFileTypes.Add(STR_FILE_TYPE_FDF);
		vsFileTypes.Add(STR_FILE_TYPE_IMPORT_FILTER);
		vsFileTypes.Add(STR_FILE_TYPE_OGS);
		vsFileTypes.Add(STR_FILE_TYPE_DATABASE);
		vsFileTypes.Add(STR_FILE_TYPE_ORIGINC);
		//#ifdef SUPPORT_PACKAGE_FILES			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vsFileTypes.Add(STR_FILE_TYPE_PACKAGE);
		//#endif								///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vsFileTypes.Add(STR_FILE_TYPE_TEMPLATE);
		vsFileTypes.Add(STR_FILE_TYPE_PATCH);
		vsFileTypes.Add(STR_FILE_TYPE_PROJECT);
		vsFileTypes.Add(STR_FILE_TYPE_THEME);
		vsFileTypes.Add(STR_FILE_TYPE_XF);
		vsFileTypes.Add(STR_FILE_TYPE_OMC);					///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vsFileTypes.Add(STR_FILE_TYPE_DEFAULT_SETTINGS);
		vsFileTypes.Add(STR_FILE_TYPE_OTHER_FILE);
		
		for ( int ii=0; ii<vsFileTypes.GetSize(); ++ii )
			vsFileTypes[ii] = "#" + ii + ";" + vsFileTypes[ii];
		
		string		strCombo;
		strCombo.SetTokens(vsFileTypes, '|');
		return strCombo;
	}
	//------ End CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
	
private:
	FilePublishBase		*m_pFilePublish;
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//int					m_nPath;
	bool					m_bSource;
	vector<bool>			m_vbShow;			// the shown cols
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	int 				m_nColStatus;
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//bool				m_bGroupMgr;				//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
};
//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
//enum
//{
	////------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	////FILE_TYPE_TEMPLATE,
	////FILE_TYPE_IMPORT_FILTER,
	////FILE_TYPE_FDF,
	////FILE_TYPE_OGS,
	////FILE_TYPE_THEME,
	//////------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
	////FILE_TYPE_PROJECT,
	////FILE_TYPE_ORIGINC,
	//////------ End SUPPORT_MORE_FILE_TYPES
	////FILE_TYPE_XF,
	////FILE_TYPE_PATCH,	//------ Folger 09/08/07 SUPPORT_PATCH_FILE
	//
	//FILE_TYPE_OGW,
	//FILE_TYPE_DIALOG_THEME,
	//FILE_TYPE_FDF,
	//FILE_TYPE_IMPORT_FILTER,
	//FILE_TYPE_OGS,
	//FILE_TYPE_ORIGINC,
	//FILE_TYPE_TEMPLATE,
	//FILE_TYPE_PATCH,
	//FILE_TYPE_PROJECT,
	//FILE_TYPE_THEME,
	//FILE_TYPE_XF,
	//FILE_TYPE_OTHER_FILE,
	////------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
//};
//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION

//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
enum		// dwSpecialFileType
{
	SPECIAL_FILE_TYPE_PACKAGE		=	0x00000001,
};
//------

///------ Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
static	bool	_is_opx_file(LPCSTR lpcszFile)
{
	string		strOPXExt = STR_PACKAGE_80_EXT;
	string		strExt;
	separate_file_name_ext(lpcszFile, NULL, &strExt);
	return strOPXExt.CompareNoCase("." + strExt) == 0 ? true : false;
}
///------ End PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

static string _registry_key_to_version(LPCSTR lpcszRegKey)
{
	// Assuming the string in format "Origin %fJunk", the version %f is 7.5, 8 or 8.1
	string strVersion(lpcszRegKey);
	strVersion = strVersion.GetToken(1, ' ');
	strVersion.TrimLeft();
	
	for(int ii=0; ii<strVersion.GetLength(); ii++)
	{
		if(strVersion[ii] != '.' && (strVersion[ii] < '0' || strVersion[ii] > '9') )
		{
			strVersion = strVersion.Left(ii);
			break;
		}
	}
	return strVersion;
}

static int _check_get_old_version_origin_registry_key(vector<string>& vsVersionKeys)
{
	vsVersionKeys.SetSize(0);

	///Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
	/*
	Registry reg(HKEY_CURRENT_USER);
	string strMainKey = STR_ORIGIN_REGISTRY_KEY;
	vector<string> vsKeys;
	if(!reg.EnumKey( vsKeys, strMainKey))
		return vsVersionKeys.GetSize();

	string strKey, strUserPath, strVersion;
	vector vdVersions;
	for(int ii=0; ii<vsKeys.GetSize(); ii++)
	{
		strVersion = _registry_key_to_version(vsKeys[ii]);
		double dVersion = atof(strVersion);
		if(dVersion == NANUM || dVersion >= CURRENT_VERSION)
			continue;
		if(get_origin_user_path(strUserPath, vsKeys[ii], true) )
		{
			vsVersionKeys.Add(vsKeys[ii]);
			vdVersions.Add(dVersion);
		}
	}
	// sort by versions
	vector<uint> vnIndex;
	vdVersions.Sort(SORT_ASCENDING, TRUE, vnIndex);
	vsVersionKeys.Reorder(vnIndex);
	*/
	vector vdVersions;
	okutil_get_installed_origins(&vdVersions, &vsVersionKeys, NULL, NULL, GETINSTALLEDORG_SORT_BY_VERSION | GETINSTALLEDORG_OLDER_VERSIONS);
	///End REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN

	return vsVersionKeys.GetSize();
}

class CategoryListMenu : public MenuBase
{
public:
	CategoryListMenu(const vector<string>& vsCategoryes)
	{
		for(int ii=0; ii<vsCategoryes.GetSize(); ii++)
			Add(vsCategoryes[ii], OnMenuItem);
	}
};

class FilePublishDlg : public ResizeDialog
{
public:
	FilePublishDlg(bool bGroupMgr = true) : ResizeDialog(IDD_FILE_PUBLISH_DLG, "ODlg8")
	{
		m_bGroupMgr = bGroupMgr;		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		m_strSpecifiedPath.Empty();			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, spicified folder empty by default, will keep last selection while running

		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		m_bFilterOlder = OM_RETURN_NO==OptionalMessageStatus("FBReplaceNewerWithOlder");
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	}
	~FilePublishDlg()
	{
		delete m_pFilePublish;
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_DESTROY(OnDestroy)
	ON_RESTORESIZE(OnRestoreSize)
	ON_GETMINMAXINFO(OnMinMaxInfo)		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	
	ON_CBN_SELCHANGE(IDC_FP_DROPDOWN, OnComboChange)
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ON_CBN_SELCHANGE(IDC_FP_VERSION_COMBO, OnVersionComboChange)
	ON_BN_CLICKED(IDC_FP_VERSION_SPECIFY, OnVersionSpecify)
	ON_GRID_MOUSE_MOVE(IDC_FP_USER_LIST, OnMouseMoveSrcFileList)
	ON_GRID_MOUSE_MOVE(IDC_FP_GROUP_LIST, OnMouseMoveDestFileList)
	ON_CBN_SELCHANGE(IDC_FP_DEST_CATEGORY_COMBO, OnDestCateComboChange)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_FP_USER_LIST, OnBeforeMouseDownUser)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_FP_GROUP_LIST, OnBeforeMouseDownGroup)
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ON_BN_CLICKED(IDC_FP_PUBLISH_BTN, OnPublish)
	ON_BN_CLICKED(IDC_FP_GET_BACK_BTN, OnGetBack)
	//ON_GRID_DBLCLICK(IDC_FP_USER_LIST, OnDblClickToSel)
	ON_BN_CLICKED(IDC_FP_REMOVE_GROUP_BTN, OnRemoveGroup)
	ON_BN_CLICKED(IDC_FP_REMOVE_USER_BTN, OnRemoveUser)
	ON_BN_CLICKED(IDC_FP_OK_BTN, OnOK)		//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	//ON_BN_CLICKED(IDC_FP_GROUP_BTN, OnSetGroupFolder)	//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
	
	ON_GRID_SEL_CHANGE(IDC_FP_USER_LIST, OnUserSelChange)
	ON_GRID_SEL_CHANGE(IDC_FP_GROUP_LIST, OnGroupSelChange)
 
	ON_HELPINFO(OnHelp)			//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP
	
EVENTS_END
	BOOL OnInitDialog()
	{
		//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		//---- CPY 9/22/2007 QA70-10384 CODE_CLEANUP
		// we no longer need to setup group folder in this dialog
		/*
		string strGroup = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		if (!strGroup.IsPath())
		{
			Control ctrl;
			if (!OnSetGroupFolder(ctrl))
			{
				SendMessage(WM_CLOSE);
				return FALSE;
			}
		}*/
		//---- end CPY 9/22/2007 QA70-10384 CODE_CLEANUP
		//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		Text = m_strDlgName = m_bGroupMgr ? STR_DLG_NAME : STR_DLG_NAME_TRANSFER_USER_FILES;
		ResizeDialog::OnInitDialog();
		
		SetInitReady();		//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		/*
		GetItem(IDC_FP_OK_BTN).Text = _L("Publish");
		
		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		if (!m_bGroupMgr)
		{
			GetItem(IDC_FP_GET_BACK_BTN).Visible = false;
			GetItem(IDC_FP_REMOVE_USER_BTN).Visible = false;
			//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
			vector<int> vnIndexMap = {
					FILE_TYPE_OGW,
					FILE_TYPE_FDF,
					FILE_TYPE_IMPORT_FILTER,
					FILE_TYPE_OGS,
					FILE_TYPE_ORIGINC,
					//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
					FILE_TYPE_PACKAGE,
#endif
					//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
					FILE_TYPE_TEMPLATE,
					FILE_TYPE_PROJECT,
					FILE_TYPE_THEME,
					FILE_TYPE_OTHER_FILE,
					FILE_TYPE_ALL_FILE		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
			};
			m_vnIndexMap = vnIndexMap;
			//------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
			
			//GetItem(IDC_FP_GROUP_BTN).Visible = false;
			
		}
		//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		GetItem(IDC_FP_GROUP_BTN).Visible = false;
		initFileTypeCombo();
				
		OnComboChange(m_FileTypeCombo);		
		
		GetItem(IDC_TOOL_TIPS).Text = STR_COLOR_EXPLAINATION;
		//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		m_btnOK = GetItem(IDC_FP_OK_BTN);
		if (!m_bGroupMgr)
			m_btnOK.Visible = false;
		else
		{
			//----- CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
			//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
			INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
			//-----
			int nIsPublished = iniFile.ReadInt(STR_SECTION, STR_IS_PUBLISHED, -1);
			m_btnOK.Enable = !nIsPublished;
		}
		//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		*/
		m_btnOK = GetItem(IDC_FP_OK_BTN);

		/// Kit 7/13/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		/// Kit 8/02/2010 ORG-539-S1 MAKE_BETTER_INFO_AFTER_FILES_MOVE
		string strShowTip;
		/// Kit 8/05/2010 ORG-539-S1 HINT_>>_CAN_NOT_SHOW_IN_GROUP_FOLDER_MANAGER
		//if( !m_bGroupMgr )
		//{
			//ocu_load_err_msg_str( MSG_SHOW_TIP_ON_LEFT_PANEL, strShowTip );
			//GetItem(IDC_FP_PUBLISH_BTN).SetToolTip( strShowTip );
		//}
		//else
		//{
			//ocu_load_err_msg_str( MSG_SHOW_TIP_ON_RIGHT_PANEL, strShowTip );
			//GetItem(IDC_FP_GET_BACK_BTN).SetToolTip( strShowTip );
		//}
		ocu_load_err_msg_str( MSG_SHOW_TIP_ON_LEFT_PANEL, strShowTip );
		GetItem(IDC_FP_PUBLISH_BTN).SetToolTip( strShowTip );
		
		if( m_bGroupMgr )
		{
			ocu_load_err_msg_str( MSG_SHOW_TIP_ON_RIGHT_PANEL, strShowTip );
			GetItem(IDC_FP_GET_BACK_BTN).SetToolTip( strShowTip );
		}
		/// End HINT_>>_CAN_NOT_SHOW_IN_GROUP_FOLDER_MANAGER
		/// End MAKE_BETTER_INFO_AFTER_FILES_MOVE
		/// End SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY

		GetItem(IDC_FP_GROUP_BTN).Visible = false;
		GetItem(IDC_TOOL_TIPS).Text = STR_COLOR_EXPLAINATION;

		initFileTypeCombo();
		initDestCategoryCombo();			// hidden by default

		if(m_bGroupMgr)
		{
			// Old Version Controls
			GetItem(IDC_FP_VERSION_STATIC).Visible = false;
			GetItem(IDC_FP_VERSION_COMBO).Visible = false;
			GetItem(IDC_FP_VERSION_SPECIFY).Visible = false;
			
			INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
			int nIsPublished = iniFile.ReadInt(STR_SECTION, STR_IS_PUBLISHED, -1);
			m_btnOK.Text = _L("Publish");
			m_btnOK.Enable = !nIsPublished;

			OnComboChange(m_FileTypeCombo);
		}
		else
		{
			GetItem(IDC_FP_GET_BACK_BTN).Visible = false;
			GetItem(IDC_FP_REMOVE_USER_BTN).Visible = false;
			m_btnOK.Visible = false;

			initOldVersionCombo();
			OnVersionComboChange(m_OldVersionCombo);			//OnComboChange will be called in OnVersionComboChange()
		}
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		return TRUE;
	}	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		if(!IsInitReady())
			return TRUE;
		//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		
		MoveControlsHelper	_temp(this);			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		uint nButtonIDs[] = {IDCANCEL, IDC_FP_OK_BTN, 0};
		ArrangeMainItemAndControls(nButtonIDs, IDC_FP_USER_LIST, NULL, false);
		
		int nEdge = GetControlGap();
			
		vector<uint> vnGroup = {IDC_FILE_TYPE, IDC_FP_DROPDOWN, 0};
		ArrangeControlsLeftRight(vnGroup, nEdge, nEdge);
		
		Control ctrlUser;
		RECT 	rrUser;
		GetControlClientRect(IDC_FP_USER_LIST, rrUser, &ctrlUser);
		
		Control ctrlGroup;
		RECT 	rrGroup;
		GetControlClientRect(IDC_FP_GROUP_LIST, rrGroup, &ctrlGroup);
		
		Control btnPublish;
		RECT 	rrPublish;
		GetControlClientRect(IDC_FP_PUBLISH_BTN, rrPublish, &btnPublish);
		
		Control btnGetBack;
		RECT	rrGetBack;
		GetControlClientRect(IDC_FP_GET_BACK_BTN, rrGetBack, &btnGetBack);
		
		Control btnRemoveUser;
		RECT	rrRemoveUser;
		GetControlClientRect(IDC_FP_REMOVE_USER_BTN, rrRemoveUser, &btnRemoveUser);
		
		Control btnRemoveGroup;
		RECT	rrRemoveGroup;
		GetControlClientRect(IDC_FP_REMOVE_GROUP_BTN, rrRemoveGroup, &btnRemoveGroup);
		
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		Control staticVersion, comboVersion, btnVersion;
		RECT rrStaticVersion, rrComboVersion, rrBtnVersion;
		GetControlClientRect(IDC_FP_VERSION_STATIC, rrStaticVersion, &staticVersion);
		GetControlClientRect(IDC_FP_VERSION_COMBO, rrComboVersion, &comboVersion);
		GetControlClientRect(IDC_FP_VERSION_SPECIFY, rrBtnVersion, &btnVersion);
		
		Control staticCate, comboCate;
		RECT rrStaticCate, rrComboCate;
		GetControlClientRect(IDC_FP_DEST_CATEGORY_STATIC, rrStaticCate, &staticCate);
		GetControlClientRect(IDC_FP_DEST_CATEGORY_COMBO, rrComboCate, &comboCate);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		int nBtnWidth = RECT_WIDTH(rrPublish);
		int nBtnHeight = RECT_HEIGHT(rrPublish);
		// DlgWidth = Gap + TreeWid + Gap + ButtonWid + ListWid + Gap, the width of List is same as the width of Tree
		int nListWidth = (RECT_WIDTH(rrUser) - 2 * nEdge - nBtnWidth) / 2;
		
		rrUser.bottom -= nBtnHeight + 2 * nEdge;
		
		rrGroup.top = rrUser.top;
		rrGroup.bottom = rrUser.bottom;
		rrGroup.right = rrUser.right;
		rrGroup.left = rrGroup.right - nListWidth;
		MoveControl(ctrlGroup, rrGroup);
		
		rrUser.right = rrUser.left + nListWidth;
		MoveControl(ctrlUser, rrUser);
		
		rrPublish.right = rrGroup.left - nEdge;
		rrPublish.left = rrPublish.right - nBtnWidth;
		MoveControl(btnPublish, rrPublish);
		
		rrGetBack.top = rrPublish.bottom + nEdge;
		rrGetBack.bottom = rrGetBack.top + nBtnHeight;
		rrGetBack.left = rrPublish.left;
		rrGetBack.right = rrPublish.right;
		MoveControl(btnGetBack, rrGetBack);
		
		int nRemoveBtnWidth = RECT_WIDTH(rrRemoveUser);
		
		rrRemoveUser.top = rrUser.bottom + nEdge;
		rrRemoveUser.bottom = rrRemoveUser.top + nBtnHeight;
		rrRemoveUser.left = rrUser.left;
		rrRemoveUser.right = rrRemoveUser.left + nRemoveBtnWidth;
		MoveControl(btnRemoveUser, rrRemoveUser);
		
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		// the same place with IDC_FP_REMOVE_USER_BTN, which will be shown if m_bGroupMgr==true
		// and these controls are only shown when m_bGroupMgr==false
		int nStaticVersionWidth = RECT_WIDTH(rrStaticVersion);
		rrStaticVersion.top = rrUser.bottom + nEdge;
		rrStaticVersion.bottom = rrStaticVersion.top + nBtnHeight;
		rrStaticVersion.left = rrUser.left;
		rrStaticVersion.right = rrStaticVersion.left + nStaticVersionWidth;
		MoveControl(staticVersion, rrStaticVersion);

		int nComboVersionWidth = RECT_WIDTH(rrComboVersion);
		int nComboVersionHeight = RECT_HEIGHT(rrComboVersion);
		rrComboVersion.top = rrUser.bottom + nEdge;
		rrComboVersion.bottom = rrComboVersion.top + nComboVersionHeight;
		rrComboVersion.left = rrStaticVersion.right + nEdge;
		rrComboVersion.right = rrComboVersion.left + nComboVersionWidth;
		MoveControl(comboVersion, rrComboVersion);

		int nBtnVersionWidth = RECT_WIDTH(rrBtnVersion);
		rrBtnVersion.top = rrUser.bottom + nEdge;
		rrBtnVersion.bottom = rrBtnVersion.top + nBtnHeight;
		rrBtnVersion.left = rrComboVersion.right + nEdge;
		rrBtnVersion.right = rrBtnVersion.left + nBtnHeight;			// width same with height
		MoveControl(btnVersion, rrBtnVersion);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

		
		rrRemoveGroup.top = rrRemoveUser.top;
		rrRemoveGroup.bottom = rrRemoveUser.bottom;
		rrRemoveGroup.left = rrGroup.left;
		rrRemoveGroup.right = rrRemoveGroup.left + nRemoveBtnWidth;
		MoveControl(btnRemoveGroup, rrRemoveGroup);
		
		Control ctrlTips;
		RECT	rrTips;
		GetControlClientRect(IDC_TOOL_TIPS, rrTips, &ctrlTips);
		
		rrTips.top = rrRemoveUser.bottom + 3 * nEdge;
		rrTips.bottom = rrTips.top + nBtnHeight;
		rrTips.left = rrRemoveUser.left + nEdge;
		rrTips.right = rrTips.left + 300;
		MoveControl(ctrlTips, rrTips);
		//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
		Control btnGroup;
		RECT	rrBtnGroup;
		GetControlClientRect(IDC_FP_GROUP_BTN, rrBtnGroup, &btnGroup);
		
		int nBtnGroupWidth = RECT_WIDTH(rrBtnGroup);
		rrBtnGroup.right = rrGroup.right;
		rrBtnGroup.left = rrBtnGroup.right - nBtnGroupWidth;
		MoveControl(btnGroup, rrBtnGroup);
		//------ End ADD_SET_GROUP_FOLDER_DIALOG
		
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		int nCateWidth = RECT_WIDTH(rrStaticCate);
		int nCateHeight = RECT_HEIGHT(rrStaticCate);
		rrStaticCate.bottom = rrGroup.top - nEdge;
		rrStaticCate.top = rrStaticCate.bottom - nCateHeight;
		rrStaticCate.left = rrGroup.left;
		rrStaticCate.right = rrStaticCate.left + nCateWidth;
		MoveControl(staticCate, rrStaticCate);

		nCateWidth = RECT_WIDTH(rrComboCate);
		nCateHeight = RECT_HEIGHT(rrComboCate);
		rrComboCate.top = rrStaticCate.top;
		rrComboCate.bottom = rrComboCate.top + nCateHeight;
		rrComboCate.left = rrStaticCate.right + nEdge;
		rrComboCate.right = rrComboCate.left + nCateWidth;
		MoveControl(comboCate, rrComboCate);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		return TRUE;
	}
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		//string strDlgName = STR_DLG_NAME;
		string strDlgName = m_bGroupMgr ? STR_DLG_NAME : STR_DLG_NAME_TRANSFER_USER_FILES;
		lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
		
		pSz->top = -1;
		pSz->left = -1;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//pSz->width = 450;  //hard code, will change later
		pSz->width = max(700, getMinWidth());
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		pSz->height = 400;  //hard code, will change later
		return TRUE;
	}

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	int	GetTotalWidth(bool bMin)
	{
		if(bMin)
			return getMinWidth();
		return ResizeDialog::GetTotalWidth(bMin);
	}

	int	GetTotalHeight(bool bMin)
	{
		return 400;
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	BOOL OnDestroy()
	{
		//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION
		if (m_FileTypeCombo)
		{
			int nCurSel = m_FileTypeCombo.GetCurSel();
			dlg_save_to_registry(m_strDlgName, STR_LAST_SELECTION, nCurSel);
			///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
			dlg_save_to_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strSpecifiedPath);
			dlg_save_to_registry(m_strDlgName, STR_OLD_VERSION_KEY, m_strCurOldVersionKey);
			///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
			
			///Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
			if( !m_bGroupMgr )
			{
				BOOL bTransferred = TRUE;
				okutil_transfer_user_files_status(&bTransferred, FALSE);
			}
			///End REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
		}
		return true;
		//------ End SAVE_USER_COMBO_SELECTION
	}
	
	BOOL OnComboChange(Control ctrl)
	{
		int nCurSel = m_FileTypeCombo.GetCurSel();
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//delete m_pFilePublish;
		////------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		//if (!m_bGroupMgr)
			//nCurSel = m_vnIndexMap[nCurSel];
		////------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		if(m_pFilePublish)
			delete m_pFilePublish;
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
		if (m_bGroupMgr && !okutil_is_group_files_update_feature_permitted())
		{
			//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				//nCurSel = FILE_TYPE_PATCH;
			switch (nCurSel)
			{
			case 0:
				nCurSel = FILE_TYPE_PATCH;
				break;
			case 1:
				nCurSel = FILE_TYPE_ALL_FILE;
				break;
			default:
				break;
			}
			//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		}			
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, show Patch file type only for group folder manager
		else if(!m_bGroupMgr)
		{
			if(nCurSel >= FILE_TYPE_PATCH)
				nCurSel += 1;
		}
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ End CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
		
		GetItem(IDC_FP_REMOVE_USER_BTN).Text = (nCurSel == FILE_TYPE_FDF || nCurSel == FILE_TYPE_TEMPLATE) ? _L("Remove") : _L("Delete");
		GetItem(IDC_FP_REMOVE_GROUP_BTN).Text = (!m_bGroupMgr && (nCurSel == FILE_TYPE_FDF || nCurSel == FILE_TYPE_TEMPLATE)) ? _L("Remove") : _L("Delete");
		
		//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
		DWORD		dwSpecialFileType = 0;
		//------
		
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//switch (nCurSel)
		//{
		//case FILE_TYPE_TEMPLATE:
			////------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			////m_pFilePublish = new TemplateTransfer();
			//if (m_bGroupMgr)
				//m_pFilePublish = new TemplatePublish();
			//else
				//m_pFilePublish = new TemplateTransfer();
			////------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//break;
		//case FILE_TYPE_IMPORT_FILTER:
			////------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			////m_pFilePublish = new ImpFilterPublish();
			//if (m_bGroupMgr)
				//m_pFilePublish = new ImpFilterPublish();
			//else
				//m_pFilePublish = new ImpFilterTransfer();
			////------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//break;
		//case FILE_TYPE_FDF:
			////------ Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			////m_pFilePublish = new FDFPublish();
			//if (m_bGroupMgr)
				//m_pFilePublish = new FDFPublish();
			//else
				//m_pFilePublish = new FDFTransfer();
			////------ End MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//break;
		//case FILE_TYPE_OGS:
			////------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			////m_pFilePublish = new OGSPublish();
			//if (m_bGroupMgr)
				//m_pFilePublish = new OGSPublish();
			//else
				//m_pFilePublish = new OGSTransfer();
			////------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//break;
		//case FILE_TYPE_THEME:
			////------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			////m_pFilePublish = new ThemePublish();
			//if (m_bGroupMgr)
				//m_pFilePublish = new ThemePublish();
			//else
				//m_pFilePublish = new ThemeTransfer();
			////------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
			//break;
		////------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
		//case FILE_TYPE_PROJECT:
			//m_pFilePublish = new ProjectPublish(STR_PROJECT_FILE_EXT, m_bGroupMgr);
			//break;
		//case FILE_TYPE_ORIGINC:
			//m_pFilePublish = new OriginCPublish(m_bGroupMgr);
			//break;
		////------ End SUPPORT_MORE_FILE_TYPES
		//
		////------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
		//case FILE_TYPE_DATABASE:
			//m_pFilePublish = new ProjectPublish(STR_DATABASE_FILE_EXT, m_bGroupMgr);
			//break;
		////------
		//
		//case FILE_TYPE_XF:
			//m_pFilePublish = new XFPublish();
			//break;
//
		/////------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
		//#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
		//case FILE_TYPE_OMC:
			//m_pFilePublish = new OMCPublish(STR_OMC_FILE_EXT, m_bGroupMgr);
			//break;
		//#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
		/////------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			//
		////------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
		//case FILE_TYPE_DEFAULT_SETTINGS:
			//m_pFilePublish = new DefaultSettingsPublish();
			//break;
		////------
			//
		////------ Folger 09/08/07 SUPPORT_PATCH_FILE
		//case FILE_TYPE_PATCH:
			//m_pFilePublish = new PatchPublish();
			//break;
		////------ End SUPPORT_PATCH_FILE	
		//
		////------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		//case FILE_TYPE_OGW:
			//m_pFilePublish = new ProjectPublish(STR_ANALYSIS_TEMPLATE_EXT, m_bGroupMgr);
			//break;
		//case FILE_TYPE_DIALOG_THEME:
			//m_pFilePublish = new DialogThemePublish();
			//break;
		//case FILE_TYPE_OTHER_FILE:
			//m_pFilePublish = new ProjectPublish(STR_OTHER_FILE_EXT, m_bGroupMgr);
			//break;
		////------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		////------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		//case FILE_TYPE_ALL_FILE:
			//m_pFilePublish = new AllFilePublish(m_bGroupMgr);
			//break;
		////------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		////------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
//#ifdef SUPPORT_PACKAGE_FILES
		//case FILE_TYPE_PACKAGE:
			///// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
			/////	if (m_bGroupMgr)
			/////		m_pFilePublish = new ProjectPublish(STR_PACKAGE_80_EXT, m_bGroupMgr);
			/////	else
			/////		m_pFilePublish = new ProjectPublish(STR_PACKAGE_75_EXT, m_bGroupMgr);
			//
			////------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
			/////------ Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
			//if ( m_bGroupMgr )
			/////------ End PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
				//dwSpecialFileType |= SPECIAL_FILE_TYPE_PACKAGE;
			////------
			//m_pFilePublish = new ProjectPublish((m_bGroupMgr ? STR_PACKAGE_80_EXT : STR_PACKAGE_75_EXT),	m_bGroupMgr, m_bGroupMgr ? STR_PACKAGE_SUB_FOLDER : "");
			///// end MORE_WORK_FOR_OPX_AND_GROUP_FOLDER
			//break;
//#endif
		////------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
		//default:
			//break;
		//}
		bool bShowCateCombo = false;
		switch (nCurSel)
		{
		case FILE_TYPE_TEMPLATE:
			if (m_bGroupMgr)
				m_pFilePublish = new TemplatePublish();
			else
				m_pFilePublish = new TemplateTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_IMPORT_FILTER:
			if (m_bGroupMgr)
				m_pFilePublish = new ImpFilterPublish();
			else
				m_pFilePublish = new ImpFilterTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_FDF:
			if (m_bGroupMgr)
				m_pFilePublish = new FDFPublish();
			else
				m_pFilePublish = new FDFTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_OGS:
			if (m_bGroupMgr)
				m_pFilePublish = new OGSPublish();
			else
				m_pFilePublish = new OGSTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_THEME:
			if (m_bGroupMgr)
				m_pFilePublish = new ThemePublish();
			else
			{
				m_pFilePublish = new ThemeTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
				bShowCateCombo = m_pFilePublish->IsSrcPathSpecified();
			}
			break;

		case FILE_TYPE_PROJECT:
			if(m_bGroupMgr)
				m_pFilePublish = new ProjectPublish(STR_PROJECT_FILE_EXT);
			else
				m_pFilePublish = new ProjectTransfer(STR_PROJECT_FILE_EXT, m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_ORIGINC:
			if(m_bGroupMgr)
				m_pFilePublish = new OriginCPublish();
			else
				m_pFilePublish = new OriginCTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_DATABASE:
			if(m_bGroupMgr)
				m_pFilePublish = new ProjectPublish(STR_DATABASE_FILE_EXT);
			else
				m_pFilePublish = new ProjectTransfer(STR_DATABASE_FILE_EXT, m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_XF:
			if(m_bGroupMgr)
				m_pFilePublish = new XFPublish();
			else
				m_pFilePublish = new XFTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_OMC:
			if(m_bGroupMgr)
				m_pFilePublish = new OMCPublish();
			else
				m_pFilePublish = new OMCTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_DEFAULT_SETTINGS:
			if(m_bGroupMgr)
				m_pFilePublish = new DefaultSettingsPublish();
			else
				m_pFilePublish = new DefaultSettingsTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_PATCH:
			if(m_bGroupMgr)
				m_pFilePublish = new PatchPublish();
			else
				m_pFilePublish = new PatchTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_OGW:
			if(m_bGroupMgr)
				m_pFilePublish = new ProjectPublish(STR_ANALYSIS_TEMPLATE_EXT);
			else
				m_pFilePublish = new ProjectTransfer(STR_ANALYSIS_TEMPLATE_EXT, m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_DIALOG_THEME:
			if(m_bGroupMgr)
				m_pFilePublish = new DialogThemePublish();
			else
				m_pFilePublish = new DialogThemeTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_OTHER_FILE:
			if(m_bGroupMgr)
				m_pFilePublish = new ProjectPublish(STR_OTHER_FILE_EXT);
			else
				m_pFilePublish = new ProjectTransfer(STR_OTHER_FILE_EXT, m_strCurOldVersionKey, m_strSpecifiedPath);
			break;

		case FILE_TYPE_ALL_FILE:
			if(m_bGroupMgr)
				m_pFilePublish = new AllFilePublish();
			else
			{
				m_pFilePublish = new AllFileTransfer(m_strCurOldVersionKey, m_strSpecifiedPath);
				bShowCateCombo = m_pFilePublish->IsSrcPathSpecified();
			}
			break;

		case FILE_TYPE_PACKAGE:
			if ( m_bGroupMgr )
			{
				dwSpecialFileType |= SPECIAL_FILE_TYPE_PACKAGE;
				m_pFilePublish = new ProjectPublish(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, STR_PACKAGE_SUB_FOLDER);
			}
			else
				m_pFilePublish = new ProjectTransfer(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, m_strCurOldVersionKey, m_strSpecifiedPath, STR_PACKAGE_SUB_FOLDER);
			break;

		default:
			break;
		}
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

		delete m_pUserList;
		delete m_pGroupList;
		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//m_pUserList = new FileListControl(IDC_FP_USER_LIST, *this, ORIGIN_PATH_USER, m_pFilePublish);
		//m_pGroupList = new FileListControl(IDC_FP_GROUP_LIST, *this, ORIGIN_PATH_GROUP, m_pFilePublish);
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		/*
		int nPathLeft, nPathRight;
		if (m_bGroupMgr)
		{
			nPathLeft = ORIGIN_PATH_USER;
			//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
			//nPathRight = ORIGIN_PATH_GROUP;
			nPathRight = ORIGIN_PATH_SERVER_GROUP_FOLDER;
			//------
		}
		else
		{
			nPathLeft = ORIGIN_PATH_USER75;
			nPathRight = ORIGIN_PATH_USER;
		}
		m_pUserList = new FileListControl(IDC_FP_USER_LIST, *this, nPathLeft, m_pFilePublish, m_bGroupMgr);
		m_pGroupList = new FileListControl(IDC_FP_GROUP_LIST, *this, nPathRight, m_pFilePublish, m_bGroupMgr);
		*/
		initDestCategoryCombo(bShowCateCombo);					// 
		m_pUserList = new FileListControl(IDC_FP_USER_LIST, *this, true, m_pFilePublish);
		m_pGroupList = new FileListControl(IDC_FP_GROUP_LIST, *this, false, m_pFilePublish);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		
		//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
		//setListColor();
		setListColor(dwSpecialFileType);
		//------ End OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
		
		GetItem(IDC_FP_PUBLISH_BTN).Enable =
		GetItem(IDC_FP_REMOVE_USER_BTN).Enable =
		GetItem(IDC_FP_GET_BACK_BTN).Enable =
		GetItem(IDC_FP_REMOVE_GROUP_BTN).Enable = false;
				
		return true;
	}

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	BOOL OnVersionComboChange(Control ctrl)
	{
		int nCurSel = m_OldVersionCombo.GetCurSel();
		if(nCurSel >= 0 && nCurSel < m_vsOldVersionKeys.GetSize())
		{
			m_strCurOldVersionKey = m_vsOldVersionKeys[nCurSel];
			m_btnVersionSpecify.Enable = false;
		}
		else
		{
			m_strCurOldVersionKey = STR_SPECIFIED_FOLDER;
			m_btnVersionSpecify.Enable = true;
		}
		//m_strSpecifiedPath.Empty();
		OnComboChange(m_FileTypeCombo);

		return false;
	}

	BOOL OnVersionSpecify(Control ctrl)
	{
		char szNewPath[MAX_PATH];
		///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
		//string strDefPath = GetAppPath();
		//if(IDOK == browse_get_path_dialog(GetSafeHwnd(), szNewPath, NULL, "Please choose a folder."))
		string	strDefPath = m_strSpecifiedPath.IsEmpty() ? okutil_get_origin_path(ORIGIN_PATH_USER) : m_strSpecifiedPath;
		if ( IDOK == browse_get_path_dialog(GetSafeHwnd(), szNewPath, strDefPath, "Please choose a folder.") )
		///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
		{
			//string strPath = BrowseGetPath(NULL, _L("Please select a folder"));
			string strPath = szNewPath;
			if(strPath.IsEmpty())
				return false;
			m_strSpecifiedPath = strPath;
			OnComboChange(m_FileTypeCombo);
			return true;
		}
		return false;
	}
	
	BOOL OnMouseMoveSrcFileList(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		if(!m_pUserList)
			return false;
		m_pUserList->OnMouseMove(cntrl, nButton, nShift, X, Y);
		return true;
	}
	BOOL OnMouseMoveDestFileList(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		if(!m_pGroupList)
			return false;
		m_pGroupList->OnMouseMove(cntrl, nButton, nShift, X, Y);
		return true;
	}

	BOOL OnDestCateComboChange(Control ctrl)
	{
		string strCate;
		int nCurSel = m_CateCombo.GetCurSel();
		if(nCurSel >= 0)
		{
			m_CateCombo.GetLBText(nCurSel, strCate);
			m_pFilePublish->SetDestCategory(strCate);
			OnComboChange(m_FileTypeCombo);
			return true;
		}
		return false;
	}

	void OnBeforeMouseDownUser(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		m_pUserList->OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
	}

	void OnBeforeMouseDownGroup(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		m_pGroupList->OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	
	//BOOL OnDblClickToSel(Control ctrl)
	//{
		//return OnAdd(ctrl);
	//}
	
	BOOL OnPublish(Control ctrl)
	{
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//vector<string> vsCategoryes;
		//if(m_pFilePublish->GetAvailableCates(vsCategoryes) > 1)
		//{
			//CategoryListMenu menu(vsCategoryes);
			//POINT pt;
			//GetCursorPos(&pt);
			////GetFocus();
			////int nx, ny;
			//int nIndex = menu.DoTrackPopup(pt.x, pt.y, GetSafeHwnd());
			//if(nIndex < 0 || nIndex >= vsCategoryes.GetSize())
				//return true;
			//
			//m_pFilePublish->SetDestCategory(vsCategoryes[nIndex]);
		//}
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		vector<string> vsFiles;
		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		//m_pUserList->FilterSelected(vsFiles, true);
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pUserList->FilterSelected(vsFiles);
		vector<bool> vbOlder;
		m_pUserList->FilterSelected(vsFiles, m_bFilterOlder, &vbOlder);	// need improve
		if(!m_bFilterOlder)
			checkRemoveOlder(vsFiles, vbOlder);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		
		int nSize = vsFiles.GetSize();
		
		m_pFilePublish->PublishFiles(vsFiles, true);	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		if (nSize != vsFiles.GetSize())
			warning_msg_box(CER_COPY_FILE, false, 'E');
		//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		m_pUserList->RestoreItemsStatus(vsFiles, true);		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		/// Kit 7/13/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		//m_pGroupList->AddRows(vsFiles);
		int nAddRowNum = m_pGroupList->AddRows(vsFiles);

		/// Kit 7/16/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		/// Kit 8/02/2010 ORG-539-S1 MAKE_BETTER_INFO_AFTER_FILES_MOVE
// 		if( !m_bGroupMgr )
// 			strOutInfo.Format( "%d File(s) transferred", nAddRowNum );
// 		else
// 			strOutInfo.Format( "%d files(s) are moved to group folder", nAddRowNum );
		string strOutInfo;
		if( !m_bGroupMgr )
		{	
			ocu_load_err_msg_str( MSG_NUM_FILES_TRANSFERRED, strOutInfo );
			strOutInfo.Format( strOutInfo, nAddRowNum );		
		}
		else
		{
			ocu_load_err_msg_str( MSG_NUM_FILES_MOVE_FROM_GROUP, strOutInfo );
			strOutInfo.Format( strOutInfo, nAddRowNum );
		}
		/// End MAKE_BETTER_INFO_AFTER_FILES_MOVE
		/// End 7/16/2010 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		
		LT_execute( "ty -a" );/// Kit 7/22/2010 ORG-539-S1 SHOW_MSG_WHATEVER_SCRIPT_WINDOW_OPEN_OR_NOT

		out_str( strOutInfo );
		/// End SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		
		//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		m_btnOK.Enable = true;
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		//------
		iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);
		//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		
		return true;
	}
	
	BOOL OnGetBack(Control ctrl)
	{
		vector<string> vsFiles;
		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		//m_pGroupList->FilterSelected(vsFiles, true);
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pGroupList->FilterSelected(vsFiles);
		vector<bool> vbOlder;

		/// Kit 7/16/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		//m_pUserList->FilterSelected(vsFiles, m_bFilterOlder, &vbOlder);
		m_pGroupList->FilterSelected(vsFiles, m_bFilterOlder, &vbOlder );
		/// End SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		
		if(!m_bFilterOlder)
			checkRemoveOlder(vsFiles, vbOlder);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		
		int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		
		m_pFilePublish->PublishFiles(vsFiles, false);
		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		if (nSize != vsFiles.GetSize())
			warning_msg_box(CER_COPY_FILE, false, 'E');
		//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		m_pGroupList->RestoreItemsStatus(vsFiles, true);	//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		
		/// Kit 7/16/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		//m_pUserList->AddRows(vsFiles);
		int nAddRowsNum = m_pUserList->AddRows(vsFiles);
		/// Kit 8/02/2010 ORG-539-S1 MAKE_BETTER_INFO_AFTER_FILES_MOVE
		string strOutInfo; 
		ocu_load_err_msg_str( MSG_NUM_FILES_MOVE_FROM_USER, strOutInfo );
		strOutInfo.Format( strOutInfo, nAddRowsNum );
		/// End MAKE_BETTER_INFO_AFTER_FILES_MOVE
		
		LT_execute( "ty -a" );/// Kit 7/22/2010 ORG-539-S1 SHOW_MSG_WHATEVER_SCRIPT_WINDOW_OPEN_OR_NOT
		
		out_str( strOutInfo );
		/// End SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
		return true;
	}
	
	BOOL OnRemoveUser(Control ctrl)
	{		
		vector<string> vsFiles;
		
		m_pUserList->GetSelFiles(vsFiles);
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		ASSERT(vsFiles.GetSize());
		string strMsg = _L("Are you sure you want to remove the files?");
		if(IDYES != warning_msg_box(strMsg, true, 'W', MB_YESNO))
			return FALSE;
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pFilePublish->RemoveFiles(vsFiles, false);
		m_pFilePublish->RemoveFiles(vsFiles, true);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		if (nSize != vsFiles.GetSize())
			warning_msg_box(CER_DELETE_FILE, false, 'E');
		//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		m_pUserList->RemoveSelRows(vsFiles);
		m_pGroupList->RestoreItemsStatus(vsFiles, false);
		
		OnGroupSelChange(ctrl);
		
		return true;
	}
	
	BOOL OnRemoveGroup(Control ctrl)
	{
		vector<string> vsFiles;
		
		m_pGroupList->GetSelFiles(vsFiles);
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		ASSERT(vsFiles.GetSize());
		string strMsg = _L("Are you sure you want to remove the files?");
		if(IDYES != warning_msg_box(strMsg, true, 'W', MB_YESNO))
			return FALSE;
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pFilePublish->RemoveFiles(vsFiles, true);
		m_pFilePublish->RemoveFiles(vsFiles, false);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		if (nSize != vsFiles.GetSize())
			warning_msg_box(CER_DELETE_FILE, false, 'E');
		//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
		m_pGroupList->RemoveSelRows(vsFiles);
		m_pUserList->RestoreItemsStatus(vsFiles, false);
		
		OnUserSelChange(ctrl);
		
		//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		m_btnOK.Enable = true;
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		//------
		iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);
		//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
		
		return true;
	}
	
	//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	BOOL OnOK(Control ctrl)
	{
		//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
		//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		//------
		int nVersion = iniFile.ReadInt(STR_SECTION, STR_VERSION, -1);
		nVersion++;
		iniFile.WriteInt(STR_SECTION, STR_VERSION, nVersion);
		iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 1);
		//m_btnOK.Enable = false;
		//_copy_essential_files();		//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		//---- CPY 9/22/2007 QA70-10384 CODE_CLEANUP
		//okutil_copy_essential_files();
		//----
		PostMessage(WM_CLOSE);
		return true;
	}
	//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
	//---- CPY 9/22/2007 QA70-10384 CODE_CLEANUP
	/*
	BOOL OnSetGroupFolder(Control ctrl)
	{
		string strGroup = okutil_get_origin_path(ORIGIN_PATH_GROUP);
		
		GETN_TREE(tr)
		GETN_STR(info, "", _L("Please enter a valid path for group folder path")) GETN_READ_ONLY_COLOR
		GETN_BUTTON(grouppath, _L("Group Path"), strGroup)
		GETN_STR_COMBO("...Path")
				
		while (GetNBox(tr, _L("Set Group Folder"), NULL, NULL, NULL, ctrl ? GetSafeHwnd() : NULL))
		{
			//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
			//if (tr.grouppath.strVal.IsPath())
			{
				//INIFileEx ini("origin.ini");
				//ini.WriteString(GROUP_PATH_SECTION, GROUP_PATH, tr.grouppath.strVal);
				string strPath = tr.grouppath.strVal;
				if (!CheckMakePath(strPath))
					continue;
				if (strPath.CompareNoCase(strGroup))
				{
					
					if (strPath.Right(1) != '\\')
						strPath += '\\';
					ocu_copy_directory(strGroup, strPath, true);
					okutil_set_server_group_path(strPath);
					if (ctrl)
						OnComboChange(ctrl);
				}
				//_copy_essential_files();
				okutil_copy_essential_files();
				return true;
			}
			//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
		}		
		
		return false;
	}
	*/
	//--- end CPY 9/22/2007 QA70-10384 CODE_CLEANUP
	//------ End ADD_SET_GROUP_FOLDER_DIALOG
	void OnUserSelChange(Control control)
	{
		if (m_pUserList)
			enableButtons(m_pUserList, IDC_FP_PUBLISH_BTN, IDC_FP_REMOVE_USER_BTN);
	}
	
	void OnGroupSelChange(Control control)
	{
		if (m_pGroupList)
			enableButtons(m_pGroupList, IDC_FP_GET_BACK_BTN, IDC_FP_REMOVE_GROUP_BTN);
	}
	
	//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = m_bGroupMgr ? IDD_GROUP_FOLDER_DLG : IDD_UUF_DLG;
		return true;
	}
	//------ End MAP_DIALOG_CHM_HELP
	
private:
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	int getMinWidth()
	{
		static int nMinWidth = 0;
		if(nMinWidth == 0)
		{
			int nEdge = GetControlGap();
			RECT 	rrFileType, rrFileDrop;
			GetControlClientRect(IDC_FILE_TYPE, rrFileType);
			GetControlClientRect(IDC_FP_DROPDOWN, rrFileDrop);
			int nMinLeft = RECT_WIDTH(rrFileType) + nEdge + RECT_WIDTH(rrFileDrop);

			RECT rrStaticCate, rrComboCate;
			GetControlClientRect(IDC_FP_DEST_CATEGORY_STATIC, rrStaticCate);
			GetControlClientRect(IDC_FP_DEST_CATEGORY_COMBO, rrComboCate);
			int nMinRight = RECT_WIDTH(rrStaticCate) + nEdge + RECT_WIDTH(rrComboCate);

			RECT 	rrPublish;
			GetControlClientRect(IDC_FP_PUBLISH_BTN, rrPublish);

			nMinWidth = 2 * max(nMinLeft, nMinRight) + RECT_WIDTH(rrPublish) + 5 * nEdge;
		}
		return nMinWidth;
	}
	
	bool checkRemoveOlder(vector<string>& vsFiles, vector<bool>& vbOlder)
	{
		bool bSkipOlder = false;
		for(int ii=vbOlder.GetSize() - 1; ii >= 0; ii--)
		{
			if(vbOlder[ii])
			{
				if( OM_RETURN_NO == OptionalMessage("FBReplaceNewerWithOlder", MB_YESNO) )
					bSkipOlder = true;
				
				m_bFilterOlder = OM_RETURN_NO==OptionalMessageStatus("FBReplaceNewerWithOlder");
				break;
			}
		}
		if(bSkipOlder)
		{
			for(ii=vbOlder.GetSize()-1; ii>=0; ii--)
			{
				if(vbOlder[ii])
				{
					vsFiles.RemoveAt(ii);
					vbOlder.RemoveAt(ii);
				}
			}
		}
		return bSkipOlder;
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	
	#define		COLOR_DARKGREEN			RGB(0, 100, 0)
	
	//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
	//void setListColor()
	void setListColor(DWORD dwSpecialFileType)
	//------
	{
		vector<string> vsUserFiles;
		vector<string> vsGroupFiles;
		
		int nUserRowOffset = m_pUserList->GetRowOffset();
		int nGroupRowOffset = m_pGroupList->GetRowOffset();
		int nUserColOffset = m_pUserList->GetColOffset();
		int nGroupColOffset = m_pGroupList->GetColOffset();
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_pUserList->GetColValues(nUserColOffset + COL_FILE, vsUserFiles, nUserRowOffset);
		//m_pGroupList->GetColValues(nGroupColOffset + COL_FILE, vsGroupFiles, nGroupRowOffset);
		m_pUserList->GetColValues(nUserColOffset + FB_COL_FILE, vsUserFiles, nUserRowOffset);
		m_pGroupList->GetColValues(nGroupColOffset + FB_COL_FILE, vsGroupFiles, nGroupRowOffset);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, always try to get the category info
		//if (m_bGroupMgr && m_pUserList->GetCols() >= COL_STATUS)
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		{
			vector<string> vsCates;
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			//m_pUserList->GetColValues(nUserColOffset + COL_CATEGORY, vsCates, nUserRowOffset);
			//_insert_string_in_vector(vsUserFiles, vsCates);
			//m_pGroupList->GetColValues(nGroupColOffset + COL_CATEGORY, vsCates, nGroupRowOffset);
			if(m_pFilePublish->IsSrcPathSpecified())			// can not get category info from gui
			{
				for(int nFile=vsUserFiles.GetSize()-1; nFile >= 0; nFile--)		// all file type
				{
					string strCategory = m_pFilePublish->GetDestCategory(vsUserFiles[nFile]);
					if(!strCategory.IsEmpty())
						vsUserFiles[nFile] = strCategory + vsUserFiles[nFile];
				}
			}
			else
			{
				m_pUserList->GetColValues(nUserColOffset + FB_COL_CATEGORY, vsCates, nUserRowOffset);
				_insert_string_in_vector(vsUserFiles, vsCates);
			}
			m_pGroupList->GetColValues(nGroupColOffset + FB_COL_CATEGORY, vsCates, nGroupRowOffset);
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			_insert_string_in_vector(vsGroupFiles, vsCates);
		}
		//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
		int nUserSize = vsUserFiles.GetSize();
		int nGroupSize = vsGroupFiles.GetSize();
		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION	
		//string strUserPath = m_pFilePublish->GetUserPath();
		//string strGroupPath = m_pFilePublish->GetGroupPath();
		//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		int nUserColStatus = m_pUserList->GetColStatus();
		int nGroupColStatus = m_pGroupList->GetColStatus();
		
		for (int ii=0; ii<nUserSize; ii++)
		{
			int nIndex = vsGroupFiles.Find(vsUserFiles[ii]);
			if (nIndex < 0)
				m_pUserList->SetRowProperties(nUserRowOffset + ii, FILE_NEW);
			else
			{
				int nUserColor = COLOR_BLUE, nGroupColor = COLOR_BLUE;
				double dUserFileTime;
				double dGroupFileTime;
				//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				//okutil_get_file_last_write_time_as_julian(strUserPath + vsUserFiles[ii], &dUserFileTime);
				//okutil_get_file_last_write_time_as_julian(strGroupPath + vsGroupFiles[nIndex], &dGroupFileTime);
				string strUserFile = vsUserFiles[ii];
				string strGroupFile = vsGroupFiles[nIndex];
				m_pFilePublish->GetFileFullPath(strUserFile, strGroupFile);
				//------ Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//okutil_get_file_last_write_time_as_julian(strUserFile, &dUserFileTime);
				//okutil_get_file_last_write_time_as_julian(strGroupFile, &dGroupFileTime);
				//------ End FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
				
				//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
				////------ Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				////double dDiff = dUserFileTime - dGroupFileTime;		//------ Folger 09/28/07 SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE
				//int nRet = file_last_modified_time_compare(strUserFile, strGroupFile);
				////------ End FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				////------ End OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
				int		nRet = 0;
				///------ Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
				//if ( dwSpecialFileType & SPECIAL_FILE_TYPE_PACKAGE )
				if ( (dwSpecialFileType & SPECIAL_FILE_TYPE_PACKAGE) || _is_opx_file(strUserFile) )
				///------ End PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
					nRet = opx_file_version_compare(strUserFile, strGroupFile);
				
				if ( nRet == 0 )
					nRet =  file_last_modified_time_compare(strUserFile, strGroupFile);
				//------ End OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
				
				//------ Folger 09/28/07 SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE
				//if (dUserFileTime > dGroupFileTime)
				//------ Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//if (dDiff > 0.5)
				if (nRet > 0)
				//------ End FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//------ End SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE
				{
					nUserColor = COLOR_RED;
					//nGroupColor = COLOR_GREEN;
					nGroupColor = COLOR_DARKGREEN;		// a little darker
					m_pUserList->SetCell(nUserRowOffset + ii, nUserColOffset + nUserColStatus, FILE_DATE_NEW);
					m_pGroupList->SetCell(nGroupRowOffset + nIndex, nGroupColOffset + nGroupColStatus, FILE_DATE_OLD);
				}
				//------ Folger 09/28/07 SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE
				//else if (dUserFileTime < dGroupFileTime)
				//------ Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//else if (dDiff < -0.5)
				else if (nRet < 0)
				//------ End FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE
				//------ End SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE
				{
					//nUserColor = COLOR_GREEN;
					nUserColor = COLOR_DARKGREEN;		// a little darker
					nGroupColor = COLOR_RED;
					m_pGroupList->SetCell(nGroupRowOffset + nIndex, nGroupColOffset + nGroupColStatus, FILE_DATE_NEW);
					m_pUserList->SetCell(nUserRowOffset + ii, nUserColOffset + nUserColStatus, FILE_DATE_OLD);
				}
				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
				//m_pUserList->SetCellColor(nUserRowOffset + ii, nUserColOffset + COL_FILE, nUserColor);
				//m_pGroupList->SetCellColor(nGroupRowOffset + nIndex, nGroupColOffset + COL_FILE, nGroupColor);
				m_pUserList->SetCellColor(nUserRowOffset + ii, nUserColOffset + FB_COL_FILE, nUserColor);
				m_pGroupList->SetCellColor(nGroupRowOffset + nIndex, nGroupColOffset + FB_COL_FILE, nGroupColor);
				///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			}
		}
		
		for (ii=0; ii<nGroupSize; ii++)
		{
			if (vsUserFiles.Find(vsGroupFiles[ii]) < 0)
				m_pGroupList->SetRowProperties(nUserRowOffset + ii, FILE_NEW);
		}
	}
	
	void initFileTypeCombo()
	{
		m_FileTypeCombo = (ComboBox)GetItem(IDC_FP_DROPDOWN);
		m_FileTypeCombo.ResetContent();
		//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		////------ Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
		//{
		////------ End CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
			//m_FileTypeCombo.AddString(_L("Template"));
			//m_FileTypeCombo.AddString(_L("Import Filter"));
			//m_FileTypeCombo.AddString(_L("Fit Function"));
			//m_FileTypeCombo.AddString(_L("OGS Files"));
			//m_FileTypeCombo.AddString(_L("Theme Files"));
			////------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
			//m_FileTypeCombo.AddString(_L("Project Files"));
			//m_FileTypeCombo.AddString(_L("OriginC Files"));
			////------ End SUPPORT_MORE_FILE_TYPES
		//}	//------ Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
		//if (m_bGroupMgr)	//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
		//{	//------ Folger 09/08/07 SUPPORT_PATCH_FILE
			//if (okutil_is_group_files_update_feature_permitted())		//------ Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
				//m_FileTypeCombo.AddString(_L("XFunctions"));
		////------ Folger 09/08/07 SUPPORT_PATCH_FILE
			//m_FileTypeCombo.AddString(_L("Patches"));
		//}
		//------ End SUPPORT_PATCH_FILE
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_OGW + "(OGW)");
		//if (m_bGroupMgr && okutil_is_group_files_update_feature_permitted())
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_DIALOG_THEME + "(OIS)");
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
		//{
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_FDF + "(FDF)");
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_IMPORT_FILTER + "(OIF)");
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_OGS + "(OGS)");
		//}
		////------ Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES
		//if ( m_bGroupMgr && okutil_is_group_files_update_feature_permitted() )
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_DATABASE + "(ODQ, ODS)");
		////------
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
		//{
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_ORIGINC + "(H, C, CPP)");
			////------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
//#ifndef SUPPORT_PACKAGE_FILES
			//m_FileTypeCombo.AddString(_STR_FILE_TYPE_TEMPLATE + "(OTP, OTW, OTM)");
//#endif			
			////------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
		//}
		//
		////------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
//#ifdef SUPPORT_PACKAGE_FILES
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
		//{
			//if (m_bGroupMgr)
				//m_FileTypeCombo.AddString(STR_FILE_TYPE_PACKAGE + "(OPX)");
			//else
				//m_FileTypeCombo.AddString(STR_FILE_TYPE_PACKAGE + "(OPK)");
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_TEMPLATE + "(OTP, OTW, OTM)");
		//}
//#endif
		////------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
		//if (m_bGroupMgr)
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_PATCH + "(EXE)");
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
		//{
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_PROJECT + "(OPJ)");
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_THEME + "(OTH)");
		//}
		//if (m_bGroupMgr && okutil_is_group_files_update_feature_permitted())
		//{
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_XF + "(OXF)");
			/////------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			//#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_OMC + "(OMC)");
			//#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__
			/////------ End SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
			////------ Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_DEFAULT_SETTINGS + "(XML)");
			////------
		//}
		//if (!m_bGroupMgr || okutil_is_group_files_update_feature_permitted())
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_OTHER_FILE + "(DOC, PDF)");
		////------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
		if(m_bGroupMgr && !okutil_is_group_files_update_feature_permitted())
		{
			m_FileTypeCombo.AddString(STR_FILE_TYPE_PATCH + "(EXE)");
		}
		else
		{
			m_FileTypeCombo.AddString(STR_FILE_TYPE_OGW + "(OGW)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_DIALOG_THEME + "(OIS)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_FDF + "(FDF)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_IMPORT_FILTER + "(OIF)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_OGS + "(OGS)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_DATABASE + "(ODQ, ODS)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_ORIGINC + "(H, C, CPP)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_PACKAGE + "(OPK, OPX)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_TEMPLATE + "(OTP, OTW, OTM)");
			if(m_bGroupMgr)			// show Patch file type only for group folder manager
				m_FileTypeCombo.AddString(STR_FILE_TYPE_PATCH + "(EXE)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_PROJECT + "(OPJ)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_THEME + "(OTH)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_XF + "(OXF)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_OMC + "(OMC)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_DEFAULT_SETTINGS + "(XML)");
			///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
			//m_FileTypeCombo.AddString(STR_FILE_TYPE_OTHER_FILE + "(DOC, PDF)");
			m_FileTypeCombo.AddString(STR_FILE_TYPE_OTHER_FILE + "(DOC, DOCX, PDF)");
			///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE
		}
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//m_FileTypeCombo.AddString(_L("All Files"));		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		m_FileTypeCombo.AddString(_L("All Supported Files"));
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		
		//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION
		//m_FileTypeCombo.SetCurSel(0);
		DWORD dwSel = 0;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, select All Files by default
		//dlg_load_registry(m_strDlgName, STR_LAST_SELECTION, dwSel);
		//if (dwSel >= m_FileTypeCombo.GetCount())
		//	dwSel = 0;
		dlg_load_registry(m_strDlgName, STR_LAST_SELECTION, dwSel, m_FileTypeCombo.GetCount()-1);
		if(dwSel >= m_FileTypeCombo.GetCount())
			dwSel = m_FileTypeCombo.GetCount()-1;
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		m_FileTypeCombo.SetCurSel(dwSel);
		//------ End SAVE_USER_COMBO_SELECTION

		///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
		dlg_load_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strSpecifiedPath);
		///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
	}
	
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	void initOldVersionCombo()
	{

		m_OldVersionCombo = GetItem(IDC_FP_VERSION_COMBO);
		m_btnVersionSpecify = GetItem(IDC_FP_VERSION_SPECIFY);
		_check_get_old_version_origin_registry_key(m_vsOldVersionKeys);

		m_OldVersionCombo.ResetContent();
		for(int ii=0; ii<m_vsOldVersionKeys.GetSize(); ii++)
		{
			m_OldVersionCombo.AddString(m_vsOldVersionKeys[ii] + " " + _L("User Files Folder"));
		}
		m_OldVersionCombo.AddString(STR_SPECIFIED_FOLDER);

		// select the latest version
		int nCurSel = m_vsOldVersionKeys.GetSize()-1;
		///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
		if ( dlg_load_registry(m_strDlgName, STR_OLD_VERSION_KEY, m_strCurOldVersionKey) && !m_strCurOldVersionKey.IsEmpty() )
		{
			int		nIndex = m_vsOldVersionKeys.Find(m_strCurOldVersionKey);
			if ( nIndex >= 0 )
			{
				nCurSel = nIndex;
			}
			else if ( compare_string_localization(m_strCurOldVersionKey, STR_SPECIFIED_FOLDER) )
			{
				++nCurSel;
			}
		}
		///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
		if(nCurSel < 0)
			nCurSel = 0;
		m_OldVersionCombo.SetCurSel(nCurSel);
	}
	
	void initDestCategoryCombo(bool bShow = false)
	{
		GetItem(IDC_FP_DEST_CATEGORY_STATIC).Visible = bShow;
		GetItem(IDC_FP_DEST_CATEGORY_COMBO).Visible = bShow;

		if(bShow)
		{
			if(!m_CateCombo)		// it's used only for theme transfer, so init it for only once
			{
				m_CateCombo = GetItem(IDC_FP_DEST_CATEGORY_COMBO);
				m_CateCombo.ResetContent();
				vector<string> vsCates;
				m_pFilePublish->GetAvailableCates(vsCates);
				for(int ii=0; ii<vsCates.GetSize(); ii++)
					m_CateCombo.AddString(vsCates[ii]);
				m_CateCombo.SetCurSel(0);
			}
			int nCurSel = m_CateCombo.GetCurSel();
			if(nCurSel >= 0)
			{
				string strCate;
				m_CateCombo.GetLBText(nCurSel, strCate);
				m_pFilePublish->SetDestCategory(strCate);
			}
		}
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	
	void enableButtons(FileListControl *filelist, int nBtnAddID, int nBtnRemoveID)
	{
		vector<string> vsFiles;
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		//filelist->FilterSelected(vsFiles);
		filelist->FilterSelected(vsFiles, m_bFilterOlder);
		///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		GetItem(nBtnAddID).Enable = vsFiles.GetSize();
		
		vector<uint> vnSelected;
		filelist->GetSelRows(vnSelected);
		GetItem(nBtnRemoveID).Enable = vnSelected.GetSize();
	}
	
private:
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	string				m_strCurOldVersionKey;
	string				m_strSpecifiedPath;
	ComboBox			m_OldVersionCombo;
	Button				m_btnVersionSpecify;
	vector<string>		m_vsOldVersionKeys;

	ComboBox			m_CateCombo;
	
	bool				m_bFilterOlder;
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ComboBox 			m_FileTypeCombo;
	FileListControl		*m_pUserList;
	FileListControl		*m_pGroupList;
	FilePublishBase		*m_pFilePublish;
	bool				m_bGroupMgr;		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	Button				m_btnOK;			//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//vector<int>			m_vnIndexMap;		//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	string				m_strDlgName;		//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION		
};
//------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
static void _insert_string_in_vector(vector<string> &vsTarget, const vector<string> &vsInsert)
{
	int nSize = vsInsert.GetSize();
	for (int ii=0; ii<nSize; ii++)
	{
		vsTarget[ii] = vsInsert[ii] + vsTarget[ii];
	}
}
//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY

BOOL OpenGroupFolderManager(HWND hParent = NULL)
{
	FilePublishDlg myDlg;
	int nRet = myDlg.DoModalEx(hParent);
	return nRet >= 0? true:false;
}
//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
BOOL OpenTransferUserFiles(HWND hParent = NULL)
{
	FilePublishDlg myDlg(false);
	int nRet = myDlg.DoModalEx(hParent);
	return nRet >= 0? true:false;
}
//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80

//void _op(bool bGroupMgr = true)
//{
	//if (bGroupMgr)
		//OpenGroupFolderManager();
	//else
		//OpenTransferUserFiles();
//}
//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
//static bool _copy_essential_files()
//{
	//vector<string> vsFilesFrom;
	//vector<string> vsFilesTo = {"OClientUpdate.exe", "OLicense.lic", "origin.ini"};
	//vsFilesFrom.Add(okutil_get_origin_path(ORIGIN_PATH_SYSTEM, "Group\\") + "OClientUpdate.exe");
	//string strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
	//vsFilesFrom.Add(strUserFolder + "OLicense.lic");
	//vsFilesFrom.Add(strUserFolder + "origin.ini");
	//string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
	//
	//for (int ii=0; ii<vsFilesFrom.GetSize(); ii++)
	//{
		//CopyFile(vsFilesFrom[ii], strGroupPath + vsFilesTo[ii]);
	//}
	//
	//return true;
//}
//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
